Option Explicit On 
Option Strict On

Imports System
Imports System.Threading

Class MonitorDemo

  Private Integers() As Integer
  Private MAX As Integer = 1000
  Private I, J As Integer

  Public Sub FillArray()
    Dim I As Integer
    ReDim Integers(MAX)
    Dim R As New Random()

    For I = 0 To Integers.Length - 1
      Integers(I) = Integers.Length - 1 - I
    Next
  End Sub

  Public Sub SortArray(ByVal State As Object)
    Monitor.Enter(Integers)

    For I = 0 To Integers.Length - 1
      For J = I + 1 To Integers.Length - 1
        If (Integers(I) > Integers(J)) Then
          Dim T As Integer = Integers(I)
          Integers(I) = Integers(J)
          Integers(J) = T
        End If
      Next

      Monitor.Wait(Integers)
      Console.Write("Posortowano: ")
      Monitor.Pulse(Integers)
    Next

    Monitor.Exit(Integers)
  End Sub

  Public Sub PrintArray(ByVal State As Object)
    Static K As Integer = 0

    Monitor.Enter(Integers)
    Monitor.Pulse(Integers)

    While (Monitor.Wait(Integers, 1000))

      If (K <= I) Then
        Console.WriteLine(Integers(K))
        K += 1
      End If

      Monitor.Pulse(Integers)
    End While

    Monitor.Exit(Integers)
  End Sub

  Public Shared Sub Main()

    Dim Demo As New MonitorDemo()
    Demo.FillArray()

    ThreadPool.QueueUserWorkItem(AddressOf Demo.SortArray)
    ThreadPool.QueueUserWorkItem(AddressOf Demo.PrintArray)

    Console.ReadLine()

  End Sub

End Class


